# Warenhaus GmbH-Seite

## Verbesserungsmöglichkeiten / Eingebaute Fehler

### SEO
Für weitere Hinweise zu SEO siehe https://www.more-fire.com/tipps/die-10-goldenen-regeln-der-seo/

- Kein responsives Design -> wirkt sich negativ auf SEO aus
- Texte mit Grafiken eingebaut -> (SEO und Barrierefreiheit)
- Titelbild nicht komprimiert -> zu groß Ladezeiten zu lang!
- Überschriften (h1, h2, h3) sind nicht hierarchisch gesetzt (siehe Artikel "Design-Herbst", "Sommer-Gewinnspiel")

### Barrierefreiheit
- Überschriften (h1, h2, h3) sind nicht hierarchisch gesetzt (siehe Artikel "Design-Herbst", "Sommer-Gewinnspiel")
- Bilder sind nicht mit alt-Attributen versehen [weitere Hinweise](http://www.die-barrierefreie-website.de/umsetzung/grafiken.html)
- ungenügender Kontrast zwischen blauer Schrift (Überschriften) und weißem Hintergrund (Farbcodes: #0077db (blau) und #ffffff (weiß))

### Rechtliche Fehler
- falsche/fehlende Impressumsangaben (siehe "Über uns") - Verstoß gegen § 5 Telemediengesetz "Allgemeine Informationspflichten"
- fehlende Datenschutzerklärung - § 13 Telemediengesetz "Pflichten des Diensteanbieters"
- fehlende Urheberrechtsangaben für Bilder und Grafiken

### Inhaltliche Fehler
- fehlende Anfahrt
- AGB -> "Under Construction", fehlen vollständig
- fehlendes Suchfeld
- veraltete Angebote "Design-Herbst", "Sommer-Gewinnspiel"
- Service-Leistungen (siehe Marketing-Mix)
- keine Möglichkeit Waren online zu betrachten oder einzukaufen
- fehlende Hinweise zur Preisangabe (z.B. "Preisangaben inkl. gesetzlicher MwSt. zzgl. Versandkosten")

## Hinweise für Lehrkräfte
### Wie kann die Webseite im Unterricht dargestellt werden?
Die Webseite liegt in Dateiform vor und kann durch Öffnen der Datei “index.html” im Browser dargestellt warden. Man kann sich dann wie gewohnt durch die Webseite klicken.
In der Praxis bedeutet dies, dass den Schülern z.B. die Dateien auf einem Rechner zur Verfügung gestellt werden müssen (z.B. auf einem Netzwerkverzeichnis, einer lokalen Festplatte oder einem USB-Stick).

Technisch versiertere Lehrkräfte können die Webseite auch auf einem lokal betriebenen Webserver (z.B. XAMP oder MAMP) zur Verfügung stellen, den die Schüler dann über eine Netzwerkverbindung aufrufen können.

### Welche Fehler sollten meine Schüler erkennen?
Es wird wahrscheinlich nicht vorkommen, dass Schüler alle eingebauten Fehler auf der Webseite erkennen werden. Erkannt werden sollten aber auf jeden Fall die Fehler im rechtlichen Bereich und die inhaltlichen Fehler.

### Wie kann ich die Webseite anpassen?
Die Dateien der Webseite können auf die individuellen Bedürfnisse der einzelnen Schulen und Schüler angepasst werden. Bearbeiten Sie die HTML- und CSS-Dateien in einem geeigneten Texteditor. Auch die Bilddateien können mit einem Grafikprogramm angepasst werden.

## Bildquellen
- Warenhaus außen Original: Maria-Anna Hartinger, privat
- Warenhaus außen Bearbeitung: Martin Kolb
- Prospekt Design-Herbst: Design komplett Martin Kolb
- Hintergrundbild Sommer-Gewinnspiel: Martin Kolb, privat
- Bearbeitung Bild Sommer-Gewinnspiel: Martin Kolb
